/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.handlers;

import com.ibm.hwmca.base.rsf.BaseRemoteSupportFacility;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfDataTransfer;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandlersErrorIds;
import com.ibm.hwmca.base.rsf.handlers.RetainUtils;
import com.ibm.hwmca.base.rsf.handlers.SdPapHandler;
import com.ibm.hwmca.base.rsf.handlers.ZPapCommandParser;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResultDetails;
import com.ibm.hwmca.base.rsf.requests.LicccRequestBody;
import com.ibm.hwmca.base.rsf.requests.PhoneListRequestBody;
import com.ibm.hwmca.base.rsf.util.RsfFileUtil;
import com.ibm.hwmca.base.rsf.util.RsfHexadecimal;
import com.ibm.hwmca.base.rsf.util.TcpConnection;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;
import com.ibm.hwmca.fw.rsf.RsfResultDetails;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.MicrocodeFunctionRequestBody;
import com.ibm.hwmca.xfw.rsf.ProblemReportRequestBody;
import com.ibm.hwmca.xfw.rsf.TopologyRequestBody;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ZPapHandler
implements BaseRsfHandlersErrorIds,
BaseRsfDataTransfer {
    private static String TRACE_MASKF = "XSSIQS F";
    private static String TRACE_MASKT = "XSSIQS T";
    private static String TRACE_MASKD = "XSSIQS D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "ZPapHandler");
    private static MicrocodeLogAttributes infoLog = MicrocodeLogAttributes.INFO_LOG;
    private static MicrocodeLogAttributes infoLogDisplayError = new MicrocodeLogAttributes(false, false, true, true, true, true, false, 0);
    private static File tempPath;
    private String tempFileName = null;
    private File tempFile = null;
    private String remotePath;
    private static final String FAILING_SYSTEM_NAME = "Failing System Name";
    private static final String HMC_SYSTEM_NAME = "HMC System Name";
    private boolean legacyRequest = false;
    private String legacyRequestClassName = "com.ibm.hwmca.z.rsf.RsfGdsRequest";
    private static String ACCT_FILES_DOWNLOADED;
    private static final String GET_PARMS = "READ_COMFILE";
    private static final String READ_FILE = "READ_FILE";
    private static final String WRITE_FILE = "WRITE_FILE";
    private static final String DISCONNECT = "DISCONNECT";
    private static final String WRITE_MCF = "WRITE_MCF";
    private static final String WRITE_PHONE_LIST = "WRITE_PHONE_LIST";
    private static final String UPDATE_PHONE_NUMBER = "UPDATE_PHONE_NUMBER";
    private static final String EXECUTE_PGM = "EXECUTE_PGM";
    private static final String WRITE_FILTER = "WRITE_FILTER";
    private static final String RETAIN_REPLY = "SEND_REPLY";
    private static final String WRITE_FIX_LIST = "WRITE_FIX_LIST";
    private static final String WRITE_FIX_FILE = "WRITE_FIX_FILE";
    public static final String FIXPACK_LIST_ATTRIBUTE = "Fixpack List";
    public static final String STAGING_DIRECTORY_ATTRIBUTE = "Staging Directory";
    private static final String attr_filename = "filename";
    private static final String attr_blocksize = "bs";
    private static final String attr_filesize = "fs";
    private static final String attr_returncode = "return code";
    private static final String attr_pgm_name = "programname";
    private static final String attr_error = "error message";
    private static final String attr_pmh = "pmh";
    private static final String attr_val_no_warranty = "Machine not warrantied";
    private static final String attr_slot = "slot";
    private static final String attr_basePn = "basePn";
    private static final String attr_configPn = "configPn";
    private static final String attr_country = "country";
    private static final String attr_region = "region";
    private static final String attr_desc = "desc";
    private static final String attr_prefix = "prefix";
    private static final String attr_multi = "multi";
    private final boolean testList = false;
    private static final String fixListTest = "<CID>WRITE_FIX_LIST</CID><FIXPACKS><FP>I01SQ001001 000</FP><FP>I01SQ001002 000</FP></FIXPACKS>";
    private static final int FIX_DESCRIPTION_LENGTH = 11;
    private static final int FIX_QUALIFIER_LENGTH = 3;
    private int response = 99;
    private static final String NO_WARRANTY_RC = "000000F0";
    private static final boolean localTrace = true;
    Socket connection;
    private String[] validTypes = new String[]{"RETAIN"};
    private String[] validVersions = new String[]{"0"};
    private static String userPwd;
    private static String encoding;
    private int papId = 0;
    private static int defaultTimeout;
    private boolean canceled = false;
    private boolean unregistered = false;
    private int errorEventId;
    private boolean warrantyRegistrationError;
    private boolean rename = true;
    private boolean writeMcfDone = false;
    private boolean mcfRequest = false;
    private boolean problemRequest = false;
    private File writeTemp = null;
    private String oldFilename = null;
    private boolean endOfWrite = false;
    private byte[] rawData;
    private int rawDataStart;
    private long writeRemainder;
    private long lastFileLength = 0L;
    private static byte[] endBytes;
    private static byte[] lcEndBytes;
    BufferedInputStream bin;
    BufferedOutputStream bout;
    private XFrameRsfRequestBody rsfRequestBody;
    private BaseRsfRequestImpl request;
    private BaseRsfResultDetails resultDetails = new BaseRsfResultDetails();
    private String requestId;
    private String currentCommand;
    private HashMap commandAttributes;
    private ArrayList phoneFiles = null;
    private boolean phoneFile = false;
    private SdPapHandler sdHandler = null;
    private String token = null;
    private boolean licccRequest = false;
    private static ArrayList byteAttributes;

    public void requestCancelling() {
        this.setCanceled(true);
    }

    public BaseRsfResultDetails getResult() {
        return this.resultDetails;
    }

    public int transmit(TcpConnection tcpPath, RsfRequestBody requestBody, BaseRsfRequestImpl request) throws IOException {
        block21: {
            if (BaseRemoteSupportFacility.testRQ) {
                Trace.trace(TRACE_MASKF, "ZPapHandler.transmit(): about to execute test wait");
                try {
                    Thread.sleep(BaseRemoteSupportFacility.testWait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                Trace.trace(TRACE_MASKF, "ZPapHandler.transmit(): finished executing test wait");
                if (this.isCanceled()) {
                    Trace.trace(TRACE_MASKF, "<- ZPapHandler.transmit(): Canceled during test wait");
                    return 99;
                }
            }
            Trace.trace(TRACE_MASKT, "-> ZPapHandler::transmit()");
            try {
                this.connection = tcpPath.getSocket();
            }
            catch (IOException e) {
                this.logInfoAndContinue("ZPapHandler: unable to get socket from path", e, (short)28486);
                this.resultDetails.setReasonCode(4);
                throw e;
            }
            this.rsfRequestBody = (XFrameRsfRequestBody)requestBody;
            this.request = request;
            if (request.getClass().getName().equals(this.legacyRequestClassName)) {
                this.legacyRequest = true;
            } else {
                String failingSystemName = request.getOriginMachine().getName();
                this.rsfRequestBody.putAttribute(FAILING_SYSTEM_NAME, failingSystemName);
                Trace.trace(TRACE_MASKF, "ZPapHandler: add attribute for 'Failing System Name' as '" + failingSystemName + "'");
            }
            String hmcSystemName = request.getHandlingMachine().getName();
            this.rsfRequestBody.putAttribute(HMC_SYSTEM_NAME, hmcSystemName);
            Trace.trace(TRACE_MASKF, "ZPapHandler: add attribute for 'HMC System Name' as '" + hmcSystemName + "'");
            try {
                this.bin = new BufferedInputStream(this.connection.getInputStream());
                this.bout = new BufferedOutputStream(this.connection.getOutputStream());
            }
            catch (IOException e) {
                this.resultDetails.setReasonCode(4);
                this.logInfoAndContinue("ZPapHandler: Exception constructing I/O streams ", e, (short)28486);
                Trace.trace(TRACE_MASKT, "<- ZPapHandler::transmit ");
                throw e;
            }
            try {
                List fileList;
                String className = this.rsfRequestBody.getClass().getName();
                if (this.rsfRequestBody instanceof MicrocodeFunctionRequestBody) {
                    this.mcfRequest = true;
                    break block21;
                }
                if (this.rsfRequestBody instanceof LicccRequestBody) {
                    this.licccRequest = true;
                    break block21;
                }
                if (!(this.rsfRequestBody instanceof ProblemReportRequestBody)) break block21;
                this.problemRequest = true;
                if (tcpPath.isHighPerformance() && ((ProblemReportRequestBody)this.rsfRequestBody).getAlternateFileListCriteria() == 1) {
                    ((ProblemReportRequestBody)this.rsfRequestBody).setUseAlternateFileList(true);
                    fileList = (List)((ProblemReportRequestBody)this.rsfRequestBody).getAlternateFileList();
                } else {
                    fileList = (List)((ProblemReportRequestBody)this.rsfRequestBody).getFileList();
                }
                if (fileList != null && !fileList.isEmpty()) {
                    File lastFile = (File)fileList.get(fileList.size() - 1);
                    String lastFilename = lastFile.getName();
                    Trace.trace(TRACE_MASKF, "ZPapHandler: problem report last file name=" + lastFilename);
                    if (lastFilename.equalsIgnoreCase("iqyylog.log")) {
                        Trace.trace(TRACE_MASKF, "ZPapHandler: setting problem report to Type A");
                        this.rsfRequestBody.putAttribute("Problem Type", "A");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "ZPapHandler: no files to be sent with problem report");
                }
                String type = this.rsfRequestBody.getAttribute("Problem Type");
                if (type == null || !type.equals("3") && !type.equals("4")) break block21;
                Trace.trace(TRACE_MASKF, "ZPapHandler.transmit: detected need for sd Pap");
                try {
                    this.sdHandler = new SdPapHandler(this, this.resultDetails, (ProblemReportRequestBody)this.rsfRequestBody);
                    this.papId = 2;
                }
                catch (ClassCastException e) {
                    this.logInternalError("ZPapHandler.transmit(): error in service director handler - invalid content type.  Found " + this.rsfRequestBody.getClass().getName(), e);
                    Trace.trace(TRACE_MASKT, "<- ZPapHandler::transmit()");
                    return 999;
                }
            }
            catch (ClassCastException c) {
                this.logInternalError("ZPapHandler.transmit(): wrong class type for request. Found " + this.rsfRequestBody.getClass().getName() + ".", c);
                this.resultDetails.setErrLogMsg("Invalid request class type.  Found " + this.rsfRequestBody.getClass().getName());
                Trace.trace(TRACE_MASKT, "<- ZPapHandler::transmit()");
                return 999;
            }
        }
        int rc = this.doProcessing();
        Trace.trace(TRACE_MASKT, "<- ZPapHandler::transmit");
        return rc;
    }

    private int doProcessing() throws IOException {
        byte[] loginRecord;
        boolean rc = false;
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::doProcessing");
        try {
            if (this.token == null) {
                this.token = RetainUtils.getRetainToken(this.request, this.resultDetails);
            }
            loginRecord = RetainUtils.getLoginInfo(this.papId, this.rsfRequestBody, this.token);
        }
        catch (IOException e) {
            this.logErrorAndContinue("ZPapHandler: I/O Exception getting auth token", e, (short)28480);
            throw e;
        }
        catch (Exception e) {
            if (this.token == null && this.request.getOwningCredentials() != null) {
                this.logErrorAndContinue("ZPapHandler: Exception getting auth token", e, (short)28480);
            } else {
                this.logInternalErrorAndContinue("ZPapHandler error getting login info", e);
            }
            this.resultDetails.setErrLogMsg("Error getting login record for " + this.rsfRequestBody.getClass().getName());
            return 999;
        }
        if (this.isCanceled()) {
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::doTransfer already canceled");
            return 99;
        }
        if (this.token == null && this.request.getOwningCredentials() != null) {
            this.logErrorAndContinue("ZPapHander: Token returned null from getToken", null, (short)28480);
            this.resultDetails.setErrLogMsg("Error: null token returned from getToken()");
            return 999;
        }
        boolean strongAuth = true;
        if (this.token == null) {
            Trace.trace(TRACE_MASKF, "ZPapHandler: login not using strong authentication");
            strongAuth = false;
        } else {
            Trace.trace(TRACE_MASKF, "ZPapHandler: login using strong authentication");
        }
        this.warrantyRegistrationError = false;
        int loginResult = RetainUtils.loginToRetain(this.request, this.connection, this.bin, this.bout, loginRecord, this.resultDetails, strongAuth);
        if (loginResult != 0) {
            this.logInfoAndContinue("ZPapHander: non success from login to RETAIN", null, (short)28530);
            try {
                this.connection.close();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "ZPapHandler::doProcessing() Error closing connection");
            }
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::doProcessing()");
            return loginResult;
        }
        boolean OK = true;
        try {
            while (OK && !this.isCanceled()) {
                OK = this.receiveCommand();
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            if (this.writeTemp != null) {
                this.writeTemp.delete();
            }
            try {
                this.connection.close();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "ZPapHandler::doProcessing() Error closing connection");
            }
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::doProcessing() OK");
            return this.response;
        }
        catch (IOException i) {
            Trace.trace(TRACE_MASKF, "ZPapHandler::doProcessing() IOException");
            Trace.trace(TRACE_MASKF, i);
            try {
                this.connection.close();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "ZPapHandler.doProcessing Error closing connection");
            }
            throw i;
        }
    }

    private boolean receiveCommand() throws IOException {
        Trace.trace(TRACE_MASKD, "-> ZPapHandler::receiveCommand()");
        String nextCommand = null;
        byte[] datalength = new byte[2];
        int timeout = defaultTimeout;
        if (this.lastFileLength > 0L) {
            timeout = 300000 + (int)this.lastFileLength * 2;
            this.lastFileLength = 0L;
        }
        this.rawData = null;
        if (!this.isCanceled()) {
            byte[] data;
            try {
                data = RetainUtils.receive(this.connection, this.bin, timeout);
                if (data == null) {
                    this.logInfoAndContinue("ZPapHandler.receiveCommand: no data in RETAIN command (probably receive timeout)", null, (short)28530);
                    this.resultDetails.setReasonCode(3);
                    this.response = 99;
                    Trace.trace(TRACE_MASKD, "<- ZPapHandler::receiveCommand() false");
                    return false;
                }
                if (data.length > 4) {
                    if (this.sdHandler != null) {
                        boolean result = this.sdHandler.processCommand(data);
                        this.response = this.sdHandler.getResult();
                        return false;
                    }
                    this.rawDataStart = RetainUtils.findXmlLength(data);
                    nextCommand = new String(data, 0, this.rawDataStart, encoding);
                    Trace.trace(TRACE_MASKD, "ZPapHandler.receiveCommand:'" + nextCommand + "'");
                    if (this.rawDataStart < data.length) {
                        this.rawData = data;
                    }
                } else {
                    nextCommand = new String(data, encoding);
                }
            }
            catch (IOException i) {
                this.logInfoAndContinue("ZPapHandler.receiveCommand: I/O Error receiving PAP request", i, (short)28592);
                Trace.trace(TRACE_MASKD, "<- ZPapHandler::receiveCommand() throw I/O Exception");
                this.resultDetails.setReasonCode(2);
                this.response = 99;
                throw i;
            }
            if (data.length == 4) {
                this.logRetainError("ZPapHandler.receiveCommand: Error from Retain Pap:" + RsfHexadecimal.buildHexadecimalString(nextCommand.getBytes(encoding)));
                Trace.trace(TRACE_MASKD, "<- ZPapHandler::receiveCommand() false");
                return false;
            }
            boolean retval = this.processCommand(nextCommand);
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::receiveCommand()" + retval);
            return retval;
        }
        Trace.trace(TRACE_MASKD, "<- ZPapHandler::receiveCommand() false");
        return false;
    }

    private boolean processCommand(String data) throws IOException {
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::processCommand()");
        ZPapCommandParser parser = new ZPapCommandParser(data);
        String command = parser.getCommand();
        if (command == null) {
            int datalength = Math.min(data.length(), 8);
            this.logRetainInfo("ZPapHandler: No command from RETAIN PAP.  First 8 (or less) bytes received=" + RsfHexadecimal.buildHexadecimalString(data.substring(0, datalength).getBytes(encoding)));
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() no command");
            return false;
        }
        HashMap attributes = parser.getAttributes();
        boolean retval = false;
        if (command.equals(GET_PARMS)) {
            retval = this.getParms(attributes);
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() GET_PARMS " + retval);
            return retval;
        }
        if (command.equals(READ_FILE)) {
            retval = this.readFile(attributes);
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() READ_FILE " + retval);
            return retval;
        }
        if (command.equals(WRITE_FILE)) {
            retval = this.writeFile(attributes, null);
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() WRITE_FILE " + retval);
            return retval;
        }
        if (command.equals(DISCONNECT)) {
            this.response = 0;
            if (this.licccRequest) {
                this.buildByteReply(data);
            } else {
                this.buildReply(attributes);
            }
            RsfResultDetails rsfDetails = this.resultDetails.getRsfResultDetails();
            if (this.writeMcfDone) {
                this.request.completedMcf(true);
                rsfDetails.putAttribute("mcf status", "00");
            } else if (this.mcfRequest) {
                rsfDetails.putAttribute("mcf status", "06");
                this.resultDetails.setReasonCode(100);
                this.resultDetails.setReasonCodeMessage(new LocalizableText("com/ibm/hwmca/rsf/res/text", "request.nomcl"));
            } else {
                this.resultDetails.setReasonCode(0);
            }
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() DISCONNECT false means disconnect");
            return false;
        }
        if (command.equals(WRITE_MCF)) {
            retval = this.writeMcf(attributes);
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() WRITE_MCF " + retval);
            return retval;
        }
        if (command.equals(WRITE_PHONE_LIST)) {
            retval = this.writePhoneList(attributes);
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() WRITE_PHONE_LIST " + retval);
            return retval;
        }
        if (command.equals(UPDATE_PHONE_NUMBER)) {
            retval = this.updatePhoneNumber(attributes);
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() UPDATE_PHONE_NUMBER " + retval);
            return retval;
        }
        if (command.equals(EXECUTE_PGM)) {
            this.request.executeProgram((String)attributes.get(attr_pgm_name));
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() EXECUTE_PGM true no matter what happened");
            return true;
        }
        if (command.equals(WRITE_FILTER)) {
            retval = this.writeFile(attributes, null);
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() WRITE_FILTER " + retval);
            return retval;
        }
        if (command.equals(WRITE_FIX_FILE)) {
            retval = this.writeFixFile(attributes);
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() WRITE_FILTER " + retval);
            return retval;
        }
        if (command.equals(WRITE_FIX_LIST)) {
            retval = this.writeFixList(parser.getFixFiles());
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() WRITE_FILTER " + retval);
            return retval;
        }
        this.logRetainInfo("Invalid command from RETAIN PAP:" + command);
        Trace.trace(TRACE_MASKT, "<- ZPapHandler::processCommand() invalid command");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildByteReply(String data) {
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::buildByteReply()");
        int dataLength = data.length();
        this.response = 0;
        RsfResultDetails rsfDetails = this.resultDetails.getRsfResultDetails();
        Iterator attributes = byteAttributes.iterator();
        while (true) {
            String valueSearch;
            int startIndex;
            int index;
            String attr;
            block10: {
                if (!attributes.hasNext()) {
                    Trace.trace(TRACE_MASKT, "<- ZPapHandler::buildByteReply()");
                    return;
                }
                attr = (String)attributes.next();
                String search1 = "<an>" + attr;
                String search2 = "<AN>" + attr;
                index = data.indexOf(search1);
                if (index < 0) {
                    index = data.indexOf(search2);
                    if (index >= 0) {
                        startIndex = index + search2.length();
                        valueSearch = "<AV>";
                        break block10;
                    } else {
                        Trace.trace(TRACE_MASKF, "ZPapHandler.buildByteReply() attribute '" + attr + "' not found");
                        continue;
                    }
                }
                startIndex = index + search1.length();
                valueSearch = "<av>";
            }
            index = data.indexOf(valueSearch, startIndex) + 4;
            if (index < 4) {
                this.logErrorAndContinue("ZPapHandler.buildByteReply() '" + valueSearch + "' not found for attribute '" + attr + "'", null, (short)28530);
                continue;
            }
            try {
                byte[] lbuffer = data.substring(index, index + 2).getBytes(encoding);
                int andByte = 127;
                int valueLength = lbuffer[1] < 0 ? lbuffer[0] * 256 + (lbuffer[1] & andByte + 128) : lbuffer[0] * 256 + lbuffer[1];
                if (valueLength + 5 < dataLength - (index += 2)) {
                    this.logErrorAndContinue("ZPapHandler.buildByteReply() Attribute value length error for " + attr + ": value length=" + valueLength + ", total data length=" + dataLength + ", and startIndex=" + index, null, (short)28530);
                    continue;
                }
                String endChars = data.substring(index + valueLength, 5);
                if (!endChars.equals("</av>") && !endChars.equals("</AV>")) {
                    this.logErrorAndContinue("ZPapHandler.buildByteReply() End of attribute value for " + attr + " contains " + endChars + ".  Should contain </AV> or </av>", null, (short)28530);
                }
                byte[] byteData = data.substring(index, index + valueLength).getBytes(encoding);
                rsfDetails.putAttribute(attr, byteData);
                Trace.trace(TRACE_MASKF, "ZPapHandler.buildByteReply: attribute " + attr + " written with " + byteData.length + " bytes.");
            }
            catch (Exception e) {
                this.logInternalError("ZPapHandler.buildByteReply() encoding problem", null);
                return;
            }
        }
    }

    private void buildReply(HashMap attributes) {
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::buildReply()");
        this.response = 0;
        RsfResultDetails rsfDetails = this.resultDetails.getRsfResultDetails();
        Iterator keys = attributes.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = (String)attributes.get(key);
            if (value == null) continue;
            Trace.trace(TRACE_MASKF, "ZPapHandler.buildReply: attribute " + key + "=" + value + ".");
            rsfDetails.putAttribute(key, value);
            if (!key.equals(attr_returncode) || value.equals("00000000")) continue;
            String errormsg = (String)attributes.get(attr_error);
            errormsg = errormsg == null ? "" : " Message from retain:\"" + errormsg + "\"";
            String logMsg = "ZPapHandler: RETAIN return code value=" + value + "." + errormsg;
            this.resultDetails.setReasonCode(3);
            if (value.equals(NO_WARRANTY_RC)) {
                logMsg = "ZPapHandler: Machine not under warranty." + errormsg;
                this.resultDetails.setReasonCode(9);
            }
            this.logInfoAndContinue(logMsg, null, (short)28530);
            this.response = 999;
        }
        if (this.phoneFiles != null && !this.phoneFiles.isEmpty()) {
            rsfDetails.putAttribute(ACCT_FILES_DOWNLOADED, this.phoneFiles);
        }
        Trace.trace(TRACE_MASKT, "<- ZPapHandler::buildReply()");
    }

    private ArrayList testFixList() {
        ZPapCommandParser parser = new ZPapCommandParser(fixListTest);
        String command = parser.getCommand();
        Trace.trace(TRACE_MASKD, "ZPapHandler.testFixList command=" + command);
        if (command.equals(WRITE_FIX_LIST)) {
            return parser.getFixFiles();
        }
        return new ArrayList();
    }

    private boolean writeFixList(ArrayList list) {
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::writeFixList()");
        boolean error = false;
        if (list == null) {
            this.logRetainInfo("ZPapHandler.writeFixList null list");
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::writeFixList() false");
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            try {
                list.set(i, this.convertFixName((String)list.get(i)));
                continue;
            }
            catch (Exception e) {
                this.logRetainInfo("Error in fix name-" + e.getMessage());
                error = true;
                list.set(i, null);
            }
        }
        this.response = 0;
        this.resultDetails.setReasonCode(0);
        RsfResultDetails rsfDetails = this.resultDetails.getRsfResultDetails();
        if (!error) {
            rsfDetails.putAttribute(FIXPACK_LIST_ATTRIBUTE, list);
        } else {
            ArrayList<String> newList = new ArrayList<String>();
            Iterator fixes = list.iterator();
            while (fixes.hasNext()) {
                String fix = (String)fixes.next();
                if (fix == null) continue;
                newList.add(fix);
            }
            rsfDetails.putAttribute(FIXPACK_LIST_ATTRIBUTE, newList);
        }
        Trace.trace(TRACE_MASKT, "<- ZPapHandler::writeFixList()");
        return true;
    }

    private boolean writeFixFile(HashMap attributes) throws IOException {
        if (this.remotePath == null) {
            this.remotePath = this.rsfRequestBody.getAttribute(STAGING_DIRECTORY_ATTRIBUTE);
            if (this.remotePath.charAt(this.remotePath.length() - 1) != File.separatorChar) {
                this.remotePath = this.remotePath + File.separatorChar;
            }
        }
        if (this.remotePath == null) {
            this.logInternalError("ZPapHandler.writeFixFile: no remote path for request body of type '" + this.rsfRequestBody.getClass().getName() + "'", null);
            return false;
        }
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::writeFixFile() remotePath: " + this.remotePath);
        try {
            attributes.put(attr_filename, this.convertFixName((String)attributes.get(attr_filename)));
        }
        catch (Exception e) {
            this.logRetainError("WriteFixFile: convert filename error -" + e.getMessage());
            return false;
        }
        Trace.trace(TRACE_MASKT, "<> ZPapHandler::writeFixFile() calling writeFile");
        return this.writeFile(attributes, this.remotePath);
    }

    /*
     * WARNING - void declaration
     */
    private String convertFixName(String input) throws IllegalArgumentException {
        void var4_4;
        String suffix;
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::convertFixName() input='" + input + "'");
        if (input == null) {
            throw new IllegalArgumentException("Fixpack file name is null");
        }
        StringTokenizer tokens = new StringTokenizer(input);
        if (tokens.countTokens() != 2) {
            throw new IllegalArgumentException("Error in fixpack file name '" + input + "': invalid number of tokens=" + tokens.countTokens() + ". Should be 2");
        }
        String[] data = new String[]{tokens.nextToken(), tokens.nextToken()};
        if (data[0].length() != 11 || data[1].length() != 3) {
            throw new IllegalArgumentException("Error in fixpack file name'" + input + "': invalid format not CPPNNSSSFFF DDD");
        }
        if (data[0].charAt(0) == 'C') {
            suffix = ".xml";
        } else if (data[0].charAt(0) == 'I') {
            suffix = ".rpm";
        } else {
            throw new IllegalArgumentException("First character of fixpack file name'" + input + "' must start with I or C");
        }
        String name = data[0].substring(1, 8) + "_" + data[0].substring(8, 11) + "_" + data[1] + (String)var4_4;
        Trace.trace(TRACE_MASKT, "<- ZPapHandler::convertFixName() to '" + name + "'");
        return name;
    }

    private boolean updatePhoneNumber(HashMap attributes) {
        this.logInternalInfoAndContinue("<> ZPapHandler::updatePhoneNumber(): Function currently not supported ", null);
        return true;
    }

    private boolean writePhoneList(HashMap attributes) throws IOException {
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::writePhoneList()");
        String filename = (String)attributes.get(attr_filename);
        if (filename == null) {
            this.logRetainError("ZPapHandler.writePhoneList: no filename in write phone list request.");
            return false;
        }
        String pathname = null;
        try {
            pathname = ((PhoneListRequestBody)this.rsfRequestBody).getStagingFilePath(filename);
        }
        catch (ClassCastException e) {
            this.logInternalError("ZPapHandler.writePhoneList: body is not of type PhoneListRequestBody but is of type " + this.rsfRequestBody.getClass().getName(), e);
            return false;
        }
        if (pathname == null) {
            this.logInternalError("ZPapHandler.writePhoneList: no staging path for " + filename, null);
            return false;
        }
        this.phoneFile = true;
        if (this.writeFile(attributes, pathname)) {
            if (this.phoneFiles == null) {
                this.phoneFiles = new ArrayList();
            }
            if (!this.phoneFiles.contains(filename)) {
                this.phoneFiles.add(filename);
            }
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::writePhoneList() OK");
            this.phoneFile = false;
            return true;
        }
        this.phoneFile = false;
        Trace.trace(TRACE_MASKT, "<- ZPapHandler::writePhoneList() unsuccessful writeFile");
        return false;
    }

    private boolean writeMcf(HashMap attributes) throws IOException {
        if (this.remotePath == null) {
            try {
                this.remotePath = ((MicrocodeFunctionRequestBody)this.rsfRequestBody).getStagingPathname();
            }
            catch (ClassCastException e) {
                this.logRetainError("WRITE_MCF received but rsfRequestBody is of type '" + this.rsfRequestBody.getClass() + "'");
                return false;
            }
        }
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::writeMcf() remotePath: " + this.remotePath);
        if (this.writeFile(attributes, this.remotePath)) {
            this.writeMcfDone = true;
            if (this.endOfWrite) {
                this.endOfWrite = false;
                this.request.completedMcf(false);
            }
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::writeMcf() true");
            return true;
        }
        Trace.trace(TRACE_MASKT, "<- ZPapHandler::writeMcf() false");
        return false;
    }

    private boolean writeFile(HashMap attributes, String path) throws IOException {
        int fileSize;
        int blockSize;
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::writeFile()");
        String filename = (String)attributes.get(attr_filename);
        if (filename == null) {
            this.logRetainError("ZPapHandler.writeFile: no filename found in RETAIN command");
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::writeFile()");
            return false;
        }
        Trace.trace(TRACE_MASKF, "ZPapHandler::writeFile(): filename=" + filename);
        String bs = null;
        String fs = null;
        try {
            bs = ((String)attributes.get(attr_blocksize)).trim();
            fs = ((String)attributes.get(attr_filesize)).trim();
        }
        catch (Exception e) {
            this.logRetainError("ZPapHandler.writeFile: Missing data from PAP - blocksize(bs):" + bs + " or filesize: " + fs);
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::writeFile()");
            return false;
        }
        try {
            blockSize = Integer.parseInt(bs);
            fileSize = Integer.parseInt(fs);
        }
        catch (Exception e) {
            this.logRetainError("ZPapHandler.writeFile: Invalid data from PAP for blocksize(bs):" + bs + " or filesize: " + fs);
            Trace.trace(TRACE_MASKT, "<- ZPapHandler::writeFile()");
            return false;
        }
        int dataLength = this.rawData.length - this.rawDataStart;
        Trace.trace(TRACE_MASKD, "ZPapHandler.writeFile: filename=" + filename + " old filename=" + this.oldFilename);
        if (!filename.equals(this.oldFilename)) {
            this.writeRemainder = fileSize;
        }
        Trace.trace(TRACE_MASKF, "ZPapHandler.writeFile: remainder=" + this.writeRemainder + " blockSize=" + blockSize + " data length=" + dataLength);
        if ((long)dataLength != this.writeRemainder && dataLength != blockSize) {
            this.logInfoAndContinue("ZPapHandler.writeFile: incorrect amount of data read: remainder=" + this.writeRemainder + " blockSize=" + blockSize + " data length=" + dataLength, null, (short)28530);
        }
        if (this.writeTemp == null || !filename.equals(this.oldFilename)) {
            if (this.writeTemp != null) {
                this.writeTemp.delete();
            }
            Trace.trace(TRACE_MASKD, "ZPapHandler.writeFile: about to create new temp file for " + tempPath);
            try {
                this.writeTemp = File.createTempFile("iqy", ".tmp", tempPath);
                this.oldFilename = filename;
            }
            catch (IOException e) {
                this.logErrorAndExit("ZPapHandler.writeFile: unable to create temp file", e, (short)28451, 7);
                return false;
            }
        }
        Trace.trace(TRACE_MASKF, "ZPapHandler.writeFile: writeFile=" + this.writeTemp);
        RetainUtils.appendToFile(this.writeTemp, this.rawData, this.rawDataStart, dataLength);
        this.rawData = null;
        if (this.writeRemainder <= (long)blockSize) {
            if (filename.substring(0, 1).equalsIgnoreCase("C")) {
                this.endOfWrite = true;
            }
            if (this.phoneFile) {
                String stagingPath = path;
                int sepChar = stagingPath.lastIndexOf(File.separatorChar) + 1;
                path = stagingPath.substring(0, sepChar);
                filename = stagingPath.substring(sepChar);
                Trace.trace(TRACE_MASKF, "ZPapHandler.writeFile phone file path=" + path + " filename=" + filename);
            }
            boolean result = RetainUtils.moveNewFile(this.request, this.writeTemp, filename, path);
            this.writeTemp = null;
            if (!result) {
                return false;
            }
        }
        this.writeRemainder -= (long)dataLength;
        Trace.trace(TRACE_MASKT, "<- ZPapHandler::writeFile() true");
        return true;
    }

    private boolean readFile(HashMap attributes) throws IOException {
        int blockSize;
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::readFile()");
        String filename = (String)attributes.get(attr_filename);
        if (filename == null) {
            this.logRetainError("ZPapHandler.readFile: no filename found in RETAIN command");
            return false;
        }
        String bs = (String)attributes.get(attr_blocksize);
        try {
            blockSize = Integer.parseInt(bs);
        }
        catch (Exception e) {
            this.logRetainError("ZPapHandler.readFile: Invalid data from PAP for blocksize:" + bs);
            return false;
        }
        boolean fileReady = true;
        if (this.tempFileName == null) {
            try {
                this.tempFile = File.createTempFile("iqy", ".tmp", tempPath);
                this.tempFileName = this.tempFile.getAbsolutePath();
            }
            catch (IOException ioe) {
                this.logInternalErrorAndContinue("ZPapHandler.readFile: Cannot create temp file", ioe);
                fileReady = false;
            }
        } else {
            try {
                this.tempFile.createNewFile();
            }
            catch (Exception e) {
                this.logInternalErrorAndContinue("ZPapHandler.readFile: Error creating new file with temp file name=" + this.tempFile.getAbsolutePath(), e);
                fileReady = false;
            }
        }
        String localFilename = this.tempFileName;
        if (fileReady) {
            if (this.request.isLocalRequest()) {
                Trace.trace(TRACE_MASKD, "ZPapHandler.readFile: copying local file for send to RETAIN");
                try {
                    FileUtilities.copy(filename, this.tempFileName);
                }
                catch (Exception e) {
                    this.logInternalErrorAndContinue("ZPapHandler.readFile: Unable to copy file locally: " + filename, e);
                    fileReady = false;
                }
            } else {
                Trace.trace(TRACE_MASKD, "ZPapHandler.readFile: transfering remote file for send to RETAIN");
                fileReady = this.request.getFile(this.tempFileName, filename, true);
            }
        }
        File localFile = new File(this.tempFileName);
        int filenameLength = filename.length();
        String fileExtension = filename.substring(filenameLength - 3, filenameLength);
        if (fileReady && !(this.rsfRequestBody instanceof TopologyRequestBody) && !fileExtension.equalsIgnoreCase("zip") && fileExtension.equalsIgnoreCase("tgz")) {
            Trace.trace(TRACE_MASKF, "ZPapHandler.readFile: attempting zip of " + filename);
            File zipFile = File.createTempFile("iqy", ".tmp", tempPath);
            String zipFileName = zipFile.getAbsolutePath();
            int zipNameIndex = !this.legacyRequest ? filename.lastIndexOf(File.separatorChar) : filename.lastIndexOf("\\");
            String zipFileEntry = localFilename;
            if (zipNameIndex >= 0 && zipNameIndex < filename.length() - 1) {
                zipFileEntry = filename.substring(zipNameIndex + 1);
            }
            RsfFileUtil.zipFile(this.tempFileName, zipFileName, zipFileEntry);
            long unzippedLength = localFile.length();
            long zippedLength = zipFile.length();
            Trace.trace(TRACE_MASKF, "ZPapHandler.readFile zip file name=" + zipFileName + ". Length=" + zippedLength + ".  Length of original file=" + unzippedLength);
            if (localFile.length() > zipFile.length()) {
                Trace.trace(TRACE_MASKF, "ZPapHandler.readFile: Zipped file is smaller than original. Using zipped file with zip entry=" + zipFileEntry);
                localFilename = zipFileName;
                localFile.delete();
            } else {
                Trace.trace(TRACE_MASKF, "ZPapHandler.readFile: Zipped file is larger than original.  Using original.");
                zipFile.delete();
            }
        }
        Trace.trace(TRACE_MASKD, "ZPapHandler.readFile: name of file to be transferred:'" + localFilename + "'");
        File file = new File(localFilename);
        int nameIndex = localFilename.lastIndexOf(File.separatorChar);
        String shortLocalName = localFilename;
        if (nameIndex >= 0 && nameIndex < localFilename.length() - 1) {
            shortLocalName = localFilename.substring(nameIndex + 1);
        }
        nameIndex = filename.lastIndexOf(File.separatorChar);
        String shortFileName = filename;
        if (nameIndex >= 0 && nameIndex < filename.length() - 1) {
            shortFileName = filename.substring(nameIndex + 1);
        }
        String preheader = "<AL><AN>filename</AN><AV>" + filename + "<AV><AN>remainder</AN><AV>";
        String postheader = "</AV></AL>";
        if (fileReady) {
            byte[] buffer = new byte[blockSize];
            try {
                Trace.trace(TRACE_MASKF, "ZPapHandler.readFile: About to get file length for '" + localFilename + "'");
                this.lastFileLength = file.length();
                Trace.trace(TRACE_MASKF, "ZPapHandler.readFile: Length of file:" + this.lastFileLength);
                FileInputStream fis = new FileInputStream(file);
                Trace.trace(TRACE_MASKD, "ZPapHandler.readFile: Created input stream for file");
                int bytesRead = blockSize;
                long remainder = this.lastFileLength;
                while (remainder > 0L && bytesRead > 0 && !this.isCanceled() && fileReady) {
                    try {
                        long bufferLength = Math.min(remainder, (long)buffer.length);
                        bytesRead = fis.read(buffer, 0, (int)bufferLength);
                    }
                    catch (IOException e) {
                        this.logErrorAndContinue("ZPapHandler.readFile: Error reading file:" + filename, e, (short)28453);
                        fileReady = false;
                    }
                    if (bytesRead < blockSize && (long)bytesRead < remainder) {
                        this.logInfoAndContinue("ZPapHandler.readFile: File shrunk? Bytes read from file=" + bytesRead + " blockSize=" + blockSize + " remainder=" + remainder, null, (short)28530);
                        remainder = bytesRead;
                    }
                    boolean endFile = false;
                    if (!fileReady || bytesRead <= 0) continue;
                    String header = preheader + remainder + postheader;
                    Trace.trace(TRACE_MASKD, "ZPapHandler.readFile: File header=" + header + ".");
                    Trace.trace(TRACE_MASKF, "ZPapHandler.readFile '" + shortFileName + "' as local file '" + shortLocalName + "' with " + remainder + " remaining bytes.");
                    endFile = remainder <= (long)bytesRead;
                    RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(header.length() + bytesRead), 2, false);
                    RetainUtils.send(this.bout, header, false);
                    RetainUtils.sendBytes(this.bout, buffer, bytesRead, endFile);
                    remainder -= (long)bytesRead;
                }
                if (this.isCanceled()) {
                    file.delete();
                    Trace.trace(TRACE_MASKT, "<- ZPapHandler::readFile() canceled");
                    return false;
                }
            }
            catch (FileNotFoundException e) {
                this.logErrorAndContinue("ZPapHandler.readFile: Can't find file:" + filename, e, (short)28453);
                fileReady = false;
                this.lastFileLength = 0L;
            }
            catch (IOException e) {
                this.logErrorAndContinue("ZPapHandler.readFile: Error sending file", e, (short)28592);
                this.lastFileLength = 0L;
                file.delete();
                Trace.trace(TRACE_MASKT, "<- ZPapHandler::readFile() throwing I/O Exception");
                throw e;
            }
        }
        if (!fileReady) {
            Trace.trace(TRACE_MASKD, "ZPapHandler.readFile sending error header to RETAIN");
            String fileData = "GET FILE FAILED";
            String errHeader = preheader + fileData.length() + postheader;
            try {
                RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(errHeader.length() + fileData.length()), 2, false);
                RetainUtils.send(this.bout, errHeader, false);
                RetainUtils.send(this.bout, fileData, true);
            }
            catch (IOException e) {
                this.logInfoAndContinue("ZPapHandler: error sending GET FILE FAILED header to RETAIN", e, (short)28592);
                throw e;
            }
        }
        Trace.trace(TRACE_MASKT, "<- ZPapHandler::readFile() true");
        return true;
    }

    private boolean getParms(HashMap attributes) throws IOException {
        Trace.trace(TRACE_MASKT, "-> ZPapHandler::getParms()");
        if (!this.isCanceled()) {
            try {
                String xml = this.rsfRequestBody.toXmlTransferFormat();
                RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(xml.length()), 2, false);
                RetainUtils.send(this.bout, xml, true);
                Trace.trace(TRACE_MASKT, "<- ZPapHandler::getParms() true");
                return true;
            }
            catch (ClassCastException e) {
                Trace.trace(TRACE_MASKF, "ZPapHandler: class cast formatting request probably due to an invalid element class in a collection");
                this.logErrorAndContinue("ZPapHandler: error formatting request for RETAIN", e, (short)28417);
                this.response = 90;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                String exceptionTrace = stringWriter.toString();
                this.resultDetails.getRsfResultDetails().putAttribute(attr_error, exceptionTrace);
                Trace.trace(TRACE_MASKT, "<- ZPapHandler::getParms() xmlTransferFormat error");
                return false;
            }
            catch (IllegalArgumentException e) {
                this.logErrorAndContinue("ZPapHandler: error formatting request for RETAIN (illegal argument)", e, (short)28417);
                this.response = 90;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                e.printStackTrace(printWriter);
                String exceptionTrace = stringWriter.toString();
                this.resultDetails.getRsfResultDetails().putAttribute(attr_error, exceptionTrace);
                Trace.trace(TRACE_MASKT, "<- ZPapHandler::getParms() xmlTransferFormat error");
                return false;
            }
            catch (IOException e) {
                this.logInfoAndContinue("ZPapHandler.processCommand: I/O Error on send parameters", e, (short)28592);
                throw e;
            }
        }
        Trace.trace(TRACE_MASKT, "<- ZPapHandler::getParms() canceled");
        return false;
    }

    synchronized void setCanceled(boolean cancel) {
        this.canceled = cancel;
    }

    synchronized boolean isCanceled() {
        return this.canceled;
    }

    private void logRetainError(String errorMsg) {
        this.resultDetails.setReasonCode(3);
        this.response = 999;
        Trace.trace(TRACE_MASKF, errorMsg);
        FrameworkLog errLog = new FrameworkLog(logInfo, 28530);
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    private void logErrorAndExit(String errorMsg, Throwable t, short errorId, int resultError) {
        FrameworkLog errLog;
        this.resultDetails.setReasonCode(resultError);
        this.response = 999;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    private void logInternalError(String errorMsg, Throwable t) {
        this.logErrorAndExit(errorMsg, t, (short)28671, 7);
    }

    private void logInternalErrorAndContinue(String errorMsg, Throwable t) {
        this.logErrorAndContinue(errorMsg, t, (short)28671);
    }

    private void logErrorAndContinue(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    private void logRetainInfo(String errorMsg) {
        this.resultDetails.setReasonCode(3);
        this.response = 99;
        Trace.trace(TRACE_MASKF, errorMsg);
        FrameworkLog errLog = new FrameworkLog(logInfo, 28530);
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private void logInfoAndExit(String errorMsg, Throwable t, short errorId, int resultError) {
        FrameworkLog errLog;
        this.resultDetails.setReasonCode(resultError);
        this.response = 99;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private void logInternalInfo(String errorMsg, Throwable t) {
        this.logErrorAndExit(errorMsg, t, (short)28671, 7);
    }

    private void logInternalInfoAndContinue(String errorMsg, Throwable t) {
        this.logErrorAndContinue(errorMsg, t, (short)28671);
    }

    private void logInfoAndContinue(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    static {
        ACCT_FILES_DOWNLOADED = "Files downloaded";
        userPwd = "URSF/PURUS    URSFTST 0924-5575        ";
        encoding = "Cp500";
        defaultTimeout = 300000;
        endBytes = new byte[]{0};
        lcEndBytes = new byte[]{0};
        byteAttributes = new ArrayList();
        try {
            tempPath = new File(BaseFileControl.getFilePath("tmp"));
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "ZPapHandler: static block - Unable to get temp file path");
            new FrameworkLog(logInfo, 28451, e).log(infoLog);
        }
        try {
            endBytes = "</AL>".getBytes(encoding);
            lcEndBytes = "</al>".getBytes(encoding);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "ZPapHandler: static block - Unable to build endBytes");
            new FrameworkLog(logInfo, 28671, e).log(infoLog);
        }
        byteAttributes.add(LicccRequestBody.RSF_PERMANENT_AP_DATA);
        byteAttributes.add(LicccRequestBody.RSF_CAPACITY_BACKUP_DATA);
        byteAttributes.add(LicccRequestBody.RSF_ADDITIONAL_AP_DATA);
        byteAttributes.add(LicccRequestBody.RSF_CAPACITY_BACKUP_PW);
    }
}

